function thetaHM = HMgo(ccpdata1,ccpdata2,pd,zd,beta,delta)
% Hotz-Miller estimation with conditioning on z

T = size(ccpdata1,2);
M = size(ccpdata1,3);

% group data by observable variables
[pzgroup, pid, zid] = findgroups(pd(:),zd(:));


% CCPs conditional on observables
ccpX1 = splitapply(@mean,ccpdata1(:),pzgroup);
ccpX2 = splitapply(@mean,ccpdata2(:),pzgroup);

nstate = size(pid,1);

ccpX = zeros(2,nstate);
ccpX(1,:) = ccpX1';
ccpX(2,:) = ccpX2';


% total state variable
pzAlli = full(ind2vec(pzgroup'))';
pzAlli = reshape(pzAlli,[T M nstate]);
pzAll = reshape(pzgroup,T,M);


pzlasti = pzAlli(1:T-1,:,:);
pzlasti = reshape(pzlasti,(T-1)*M,nstate);
pznexti = pzAlli(2:T,:,:);
pznexti = reshape(pznexti,(T-1)*M,nstate);


pzgrouplast = reshape(pzgroup,T,M);
pzgrouplast = pzgrouplast(1:(T-1),:);
pzgrouplast = pzgrouplast(:);



% transition process
% for missing observations, assume stays in state
tranpz = eye(nstate);

for i = 1:nstate
  % indices with given starting state
  indices = find(pzgrouplast==i);

  % grab "next" observations resulting from that state
  if ~isempty(indices)
    nextobs = pznexti(indices,:);

    % compute transition probabilities
    tranpz(i,:) = mean(nextobs);
  end
end


trank1 = [1, 0; delta, 1-delta];
trank2 = [0, 1; 0, 1];
trank1_temp = reshape(trank1,[2 1 2 1]);
trank2_temp = reshape(trank2,[2 1 2 1]);
tranpz_temp = reshape(tranpz,[1 nstate 1 nstate]);

tranAll1 = trank1_temp(:,ones(nstate,1),:,ones(nstate,1)).* ...
           tranpz_temp(ones(2,1),:,ones(2,1),:);
tranAll2 = trank2_temp(:,ones(nstate,1),:,ones(nstate,1)).* ...
           tranpz_temp(ones(2,1),:,ones(2,1),:);

ntot = 2*nstate;
transMat1 = reshape(tranAll1,ntot,ntot);
transMat2 = reshape(tranAll2,ntot,ntot);

% values of k across full state variables
kdum = [0;1];
kvec = kdum(:,ones(nstate,1));
kvec = reshape(kvec,ntot,1);

% values of p across full state variables
pvec = pid';
pvec = reshape(pvec(ones(2,1),:),ntot,1);

% A matrix from transition process
Amat = (eye(ntot) - beta*transMat2)*inv(eye(ntot) - beta*transMat1);

% b vector from CCPs
ccpvec = reshape(ccpX,ntot,1);
phi1 = double(eulergamma) - log(reshape(1-ccpvec,ntot,1));
phi2 = double(eulergamma) - log(reshape(ccpvec,ntot,1));
bvec = Amat*phi1 - phi2;


xHM = [(ones(ntot,1) - Amat*kvec), pvec];
thetaHM = inv(xHM'*xHM)*xHM'*bvec;
