
% ------------------------------------------------------------------------------
% illustrate bias and performance of different linear estimators
% stats: mean estimate, bias, sd, RMSE
% vary sample structure, and for each sample structure,
% consider three cases:
% 1. no unobserved demand shocks, no macro shocks
% 2. no macro shocks, with unobserved demand shock
% 3. macro shocks in IV, with unobserved demand shock
%
% I always simulate T+1 time periods to make it easier to compare
% number of observations across M and T. Note that the regressions
% always throw out one of the simulated time periods due to the
% use of next period CCPs. Thus, Im setting it up so M*T is the
% number of market-periods in the regressions.

% we can run this code in parallel with different seeds
% if seed not set, set a default
if ~exist('seed')
  seed = 12345;
end
rng(seed)

NS = 500; % number of replications
split = 10; % number of runs to split replications into (helps keep within memory constraints)

% parameters that are fixed across replications
step = 1; % 1/step is space between grid points
lu = 0; % proportion of macro shocks for u
%le = .8; % proportion of macro shocks for e
le = 0; % proportion of macro shocks for e

% parameters that vary
lzList =  [0, .7];  % proportion of macro shocks for z
s2uList = [0, 16];  % proportion of macro shocks for u


% CCPs for different processes
ccp_array = {};
for s2ui = 1:length(s2uList)
for lzi = 1:length(lzList)

  s2u = s2uList(s2ui);
  lz = lzList(lzi);
  ccp_array{s2ui,lzi} = get_ccp(step,lu,lz,le,s2u)

end
end

Nlist = [10 40 160];

% to store results
thetaOLS_all        = zeros(length(Nlist),length(Nlist),length(s2uList),length(lzList),NS,2);
thetaIV_all         = zeros(length(Nlist),length(Nlist),length(s2uList),length(lzList),NS,2);
thetaHM_all         = zeros(length(Nlist),length(Nlist),length(s2uList),length(lzList),NS,2);
thetaHMs_all        = zeros(length(Nlist),length(Nlist),length(s2uList),length(lzList),NS,2);

lreArray = zeros(NS,8);

% run the monte carlo for various sample sizes and parameters
for mi = 1:length(Nlist)
for ti = 1:length(Nlist)
for s2ui = 1:length(s2uList)
for lzi = 1:length(lzList)
for subs = 1:split
  sstart = (subs-1)*NS/split+1;
  send = subs*NS/split;

  M = Nlist(mi);
  T = Nlist(ti);
  s2u = s2uList(s2ui);
  lz = lzList(lzi);
  [M,T,s2u,lz,subs]

  if (M==160) & (T==160) & (s2ui==2) & (lzi==2)
    % compute and record LREs only for this "main" simulation
    [thetaOLS thetaIV thetaHM thetaHMs lreAll] = MCrun_full(NS/split,M,T+1,step,lu,lz,le,s2u,ccp_array{s2ui,lzi});
    lreArray(sstart:send,:) = lreAll;
  else
    [thetaOLS thetaIV thetaHM thetaHMs] = MCrun(NS/split,M,T+1,step,lu,lz,le,s2u,ccp_array{s2ui,lzi});
  end
  thetaOLS_all(mi,ti,s2ui,lzi,sstart:send,:) = thetaOLS;
  thetaIV_all(mi,ti,s2ui,lzi,sstart:send,:) = thetaIV;
  thetaHM_all(mi,ti,s2ui,lzi,sstart:send,:) = thetaHM;
  thetaHMs_all(mi,ti,s2ui,lzi,sstart:send,:) = thetaHMs;
end
end
end
end
end


save(['MCresults', num2str(seed), '.mat'])
