
% NS: number of simulations
% M: number of markets
% T: number of time periods
% step: inverse of width of bins for discretization
% seed: random seed
% lu: fraction of u variance that is aggregate
% lz: fraction of z variance that is aggregate

% NS = 100
% M = 10
% T = 100
% step = 4
% lu = 0
% lz = .5
% le = 0
% s2u = .2

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%;
%A. Set primitives of the model;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%;

beta  = 0.95;             % Discount Factor
sigma2_u = s2u;          % Variance of shocks
set_params;

%********************************************************;
%B. Simulate the Price Data
%********************************************************;

% Store data
u = zeros(NS,T,M);
z = zeros(NS,T,M);
e = zeros(NS,T,M);

% Initial draw from steady-state distribution
ushock = sqrt(1-lu)*randn(NS,1,M) + sqrt(lu)*randn(NS,1,1);
u(:,1,:) = rho0_u / (1 - rho1_u) + sqrt(sigma2_u / (1 - rho1_u^2)) * ushock;
zshock = sqrt(1-lz)*randn(NS,1,M) + sqrt(lz)*randn(NS,1,1);
z(:,1,:) = rho0_z / (1 - rho1_z) + sqrt(sigma2_z / (1 - rho1_z^2)) * zshock;
eshock = sqrt(1-le)*randn(NS,1,M) + sqrt(le)*randn(NS,1,1);
e(:,1,:) = rho0_e / (1 - rho1_e) + sqrt(sigma2_e / (1 - rho1_e^2)) * eshock;

% generate U and Z
for t=2:T
        ushock = sqrt(1-lu)*randn(NS,1,M) + sqrt(lu)*randn(NS,1,1);
        u(:,t,:) = rho0_u + rho1_u * u(:,t-1,:) + sqrt(sigma2_u) * ushock;
        zshock = sqrt(1-lz)*randn(NS,1,M) + sqrt(lz)*randn(NS,1,1);
        z(:,t,:) = rho0_z + rho1_z * z(:,t-1,:) + sqrt(sigma2_z) * zshock;
        eshock = sqrt(1-le)*randn(NS,1,M) + sqrt(le)*randn(NS,1,1);
        e(:,t,:) = rho0_e + rho1_e * e(:,t-1,:) + sqrt(sigma2_e) * eshock;
end



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% C. Discretize
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% indexed arrays of state variables
zix = index(z,zgrids_half);
uix = index(u,ugrids_half);
eix = index(e,egrids_half);

% discretized data
zd = zgrids(zix);
ud = ugrids(uix);
ed = egrids(eix);

% ------------------------------------------------
% alternative process
%eix = zeros(NS,T,M);
%for n = 1:NS
%for m = 1:M
%  eix(n,:,m) = reshape(sim_markov(trane,eSS,T),[1,T,1]);
%end
%end

%ed = egrids(eix);
%e = ed;
% ------------------------------------------------


Pd = gamma0 + gamma1 * zd + gamma2 * ud + ed;

% combined u+e residual for when xi(u) is unobservable
minx = min(min(min(ud))) + min(min(min(ed)));
maxx = max(max(max(ud))) + max(max(max(ed)));
xgrids = (minx:(1/step):maxx)';
xgrids_half=(minx:(1/(2*step)):maxx)';
x = e + u;
xix = index(x,xgrids_half);
xd = xgrids(xix);

%********************************************************;
% D. Use Value Function Iteration to obtain value functions
%********************************************************;

% solve for value function and CCPs
%[ccp ev] = vf_solve(theta,delta,beta,gamvec,trane,tranz,tranu,egrids,zgrids,ugrids);

% probability of purchase for each simulated market state
% and for each individual state
ccpfn1 = @(e,z,u) ccp(2,1,e,z,u);
ccpfn2 = @(e,z,u) ccp(2,2,e,z,u);

ccpdata1 = arrayfun(ccpfn1,eix,zix,uix);
ccpdata2 = arrayfun(ccpfn2,eix,zix,uix);


%********************************************************;
% E. Regressions
%********************************************************;

% note: only using the no-ownership state for estimation

% static logit dependent variable
Ylogit = log(ccpdata1./(1-ccpdata1));

% dynamic component of dependent variable
Y2 = log(ccpdata2./ccpdata1);

% full dynamic dependent variable
Yfull = Ylogit(:,1:(T-1),:) + beta*Y2(:,2:T,:);


ytemp = reshape(Yfull(1,:,:),T-1,M);
ptemp = reshape(Pd(1,1:(T-1),:),T-1,M);
ztemp = reshape(zd(1,1:(T-1),:),T-1,M);
utemp = reshape(ud(1,1:(T-1),:),T-1,M);

% cell of arrays with cell for each simulation
Yfullc = num2cell(Yfull,[2 3]);
Pc = num2cell(Pd(:,1:(T-1),:),[2 3]);
zc = num2cell(zd(:,1:(T-1),:),[2 3]);
uc = num2cell(ud(:,1:(T-1),:),[2 3]);

% run each regression for each simulation
thetaOLSc     = cellfun(@regOLS,Yfullc,Pc,zc,uc,'UniformOutput',false);
thetaIVc      = cellfun(@regIV,Yfullc,Pc,zc,uc,'UniformOutput',false);

thetaOLS = cell2mat(thetaOLSc')';
thetaIV = cell2mat(thetaIVc')';

% Hotz-Miller estimation using formulas from previous KSS paper, section 2
% Use observed transition process for (z,x)
ccp1c = num2cell(ccpdata1,[2 3]);
ccp2c = num2cell(ccpdata2,[2 3]);
pdc = num2cell(Pd,[2 3]);
zdc = num2cell(zd,[2 3]);
thetaHMc = cellfun(@(a,b,c,d) reshape(HMgo(a,b,c,d,beta,delta),[1 2]),ccp1c,ccp2c,pdc,zdc,'UniformOutput',false);
thetaHM = cell2mat(thetaHMc);

thetaHMsc = cellfun(@(a,b,c,d) reshape(HM_simple(a,b,c,d,beta,delta),[1 2]),ccp1c,ccp2c,pdc,zdc,'UniformOutput',false);
thetaHMs = cell2mat(thetaHMsc);
