function [thetaOLS thetaIV thetaHM thetaHMs lreAll] = MCrun_full(NS,M,T,step,lu,lz,le,s2u,ccp)

MCgo;

%********************************************************;
% F. Long-run Elasticities
%********************************************************;

% combined u+e residual for when xi(u) is unobservable
minx = min(min(min(ud))) + min(min(min(ed)));
maxx = max(max(max(ud))) + max(max(max(ed)));
xgrids = (minx:(1/step):maxx)';
xgrids_half=(minx:(1/(2*step)):maxx)';
x = e + u;
xix = index(x,xgrids_half);
xd = xgrids(xix);

% indexed prices and transition process if we ignore other state variables
minp = min(min(min(Pd)));
maxp = max(max(max(Pd)));
pgrids = (minp:(1/step):maxp)';
pgrids_half=(minp:(1/(2*step)):maxp)';
pix = index(Pd,pgrids_half);

eixc = num2cell(eix,[2 3]);
zixc = num2cell(zix,[2 3]);
uixc = num2cell(uix,[2 3]);
xixc = num2cell(xix,[2 3]);
pixc = num2cell(pix,[2 3]);

dg0 = .01;
beta=.95;

% compute long run elasticties for various parameter estimates
[lre_real_OLS lre_feas_OLS] = cellfun(@(a,b,c,d) ...
      lre(dg0,meanP,a,delta,beta,gamvec,b,c,d,egrids,zgrids,ugrids,xgrids,tranu), ...
      thetaOLSc,eixc,zixc,xixc,'UniformOutput',false);
lre_real_OLS = cell2mat(lre_real_OLS);
lre_feas_OLS = cell2mat(lre_feas_OLS);

[lre_real_IV lre_feas_IV] = cellfun(@(a,b,c,d) ...
      lre(dg0,meanP,a,delta,beta,gamvec,b,c,d,egrids,zgrids,ugrids,xgrids,tranu), ...
      thetaIVc,eixc,zixc,xixc,'UniformOutput',false);
lre_real_IV = cell2mat(lre_real_IV);
lre_feas_IV = cell2mat(lre_feas_IV);

[lre_real_HM lre_feas_HM] = cellfun(@(a,b,c,d) ...
      lre(dg0,meanP,a,delta,beta,gamvec,b,c,d,egrids,zgrids,ugrids,xgrids,tranu), ...
      thetaHMc,eixc,zixc,xixc,'UniformOutput',false);
lre_real_HM = cell2mat(lre_real_HM);
lre_feas_HM = cell2mat(lre_feas_HM);

[lre_real_HMs lre_feas_HMs] = cellfun(@(a,b) ...
      lre_simple(dg0,meanP,a,delta,beta,gamvec,b,pgrids,ugrids,tranu), ...
      thetaHMsc,pixc,'UniformOutput',false);
lre_real_HMs = cell2mat(lre_real_HMs);
lre_feas_HMs = cell2mat(lre_feas_HMs);

lreAll = [lre_real_OLS lre_feas_OLS lre_real_IV lre_feas_IV lre_real_HM lre_feas_HM lre_real_HMs lre_feas_HMs];
