function [zgrids, zgrids_half, nd] = discretize(step,theta_0,theta_1,theta_2)

%This function takes an AR(1) process and discretizes it into 'nd' bins
%The inputs are the number of evaluation points (nd), and the
%parameters in the AR(1) process
%yt=theta_0 + theta_1*yt-1 + epsilon where epsilon ~ N(0,theta_2)
%The output of the function is the evaluation grid as well has the half grid (grid with midpoints)
%
% 1/step is the width between grid points
% nd is the number of points in the discretization
% we do this so that the different variables affecting price live on a common
% discretization, and so that we can't recover the value of u by observing (z,p)


if (theta_2 == 0)
  nd = 1;
  zgrids = theta_0/(1-theta_1)*ones(1,nd);
  zgrids_half = theta_0/(1-theta_1)*ones(1,nd);

else
  %unconditional distribution of z;
  %z ~N(theta_z[1]/(1-theta_z[2]),theta_z[3]^2/(1-theta_z[2]^2)
  %Calculate the relevant range of z for both of the scenarios.

  %one percent1ile
  zmin = theta_0/(1-theta_1)+sqrt((theta_2^2)/(1-theta_1^2))*norminv(0.01);
  zmin = floor(zmin*step)/step;

  %ninty-nine percentile;
  zmax = theta_0/(1-theta_1)+sqrt((theta_2^2)/(1-theta_1^2))*norminv(0.99);
  zmax = ceil(zmax*step)/step;

  nd = (zmax - zmin)*step+1;


  %The range of the state variable;
  %Display the mean variance, one percentile and ninety nine percentile for
  %both the factual and the counterfactual scenario

  %disp('the mean, variance, one percentile and ninty-nine percentile of the state variable z');
  %[theta_0/(1-theta_1) (theta_2^2)/(1-theta_1^2) zmin zmax]


  %Construct evaulation grids;
      %pick the smallest of zmin and zmin1 at one end point
      %pick the greatest of zmax and zmax1 at the other end point
      %construct evenly divided grids between these two points
  zgrids=(zmin:(1/step):zmax)';  %nd x 1 vector
  zgrids_half=(zmin:(1/(2*step)):zmax)'; % 2*nd -1 x 1 vector
end
