function etrans = estTrans(ixdata,grids)
% estimate transition matrix 

T = size(ixdata,1);
M = size(ixdata,2);
nd = size(grids,1);


% convert indexed array to array of dummy vars
zixC = num2cell(ixdata,2);
zixD = cellfun(@(x) reshape(full(ind2vec(reshape(x,1,M),nd))',[1 M nd]),zixC,'UniformOutput',false );
zixD = cell2mat(zixD);

% compute transition frequencies
zixDnext = zixD(2:T,:,:);
zixDnext = reshape(zixDnext,[(T-1) M 1 nd]);
zixDlast = zixD(1:T-1,:,:);

% deal with divide by zeros by adding small amount denominator and diagonal numerator
zixTrans = zixDnext(:,:,ones(nd,1),:).*zixDlast(:,:,:,ones(nd,1));
zixTrans = sum(sum(zixTrans,1),2);
small = .00001;
eps = reshape(small*eye(nd,nd),[1 1 nd nd]);
zixTrans = sum(sum(zixTrans,1),2) + eps;
zixStart = sum(sum(zixDlast,1),2)+small;

etrans = zixTrans./zixStart(:,:,:,ones(nd,1));
etrans = reshape(etrans,nd,nd);
