function [vof] = index(P,Pgrids_half)

%This function takes a vector of continuous variables and places each
%element into one of the 'nd' bins in the evaluation grid
%It takes as inputs the number of evaluation points (nd), a vector of
%continuous variables (P) and the evaluation grid with midpoints
%(Pgrids_half)
%The output of the function is the index - which bin each element of the
%vector P belongs to

nd = (size(Pgrids_half,1)+1)/2;

if nd==1
  vof = P*0+1;
else
  vof=P*0;
  for i=2:nd-1
    vof(boolean((P <= Pgrids_half(2*i)).*(P > Pgrids_half(2*(i - 1))))) = i;
  end
  vof( P<=Pgrids_half(2) )  = 1;
  vof( P>Pgrids_half(2*(nd-1)) )  = nd;
end



%vof=zeros(T,m);
%for t=1:size(P,1)
%    for k=1:size(P,2)
%    for j=2:nd-1
%        if P(t,k)<=Pgrids_half(2*j) && P(t,k)>Pgrids_half(2*(j-1));
%            vof(t,k)=j;
%        end
%    end
%    if P(t,k)<=Pgrids_half(2)
%        vof(t,k)=1;
%    elseif P(t,k)>Pgrids_half(2*(nd-1))
%        vof(t,k)=nd;
%    end
%    end
%end
