function dTotal = lrd(theta,delta,beta,gamvec,trane,tranz,tranu,egrids,zgrids,ugrids);
% calculate long-run demand level

% solve dynamic problem
[ccp ev] = vf_solve(theta,delta,beta,gamvec,trane,tranz,tranu,egrids,zgrids,ugrids);
% stationary distribution of all states
[muAll ccp_agg] = stationary(ccp,trane,tranz,tranu,delta);

nz = size(muAll,2);
nu = size(muAll,3);

muTemp = reshape(muAll,[1 2 nz nu]);
cp = ccp_agg.*muTemp(ones(2,1),:,:,:); % unconditional choice probs

% overall frequency of purchase
dTotal = sum(sum(sum(cp,2),3),4);
dTotal = dTotal(2);
