function [lre_real lre_feas] = lre(dg0,meanP,theta,delta,beta,gamvec,eix,zix,xix,egrids,zgrids,ugrids,xgrids,tranu);
% dg0: the change in gamma0
% note that changes in gamma0 are one-to-one with changes in the mean price

theta = reshape(theta,2,1);
theta = [theta;1]; % coefficient on xi is 1 -- this wont matter in feasible version

T = size(zix,2);
M = size(zix,3);

% estimated transition matrices
etranz = estTrans(reshape(zix,T,M),zgrids);
etrane = estTrans(reshape(eix,T,M),egrids);
etranx = estTrans(reshape(xix,T,M),xgrids);

% put the change in gamma0 into the e residual
egrids_cf = egrids + dg0;
xgrids_cf = xgrids + dg0;

d_real_base = lrd(theta,delta,beta,gamvec,etrane,etranz,tranu,egrids,zgrids,ugrids);
d_real_cf   = lrd(theta,delta,beta,gamvec,etrane,etranz,tranu,egrids_cf,zgrids,ugrids);

% in "feasible" counterfactual, unobserved demand shocks are fixed at zero,
% and the residual of the pricing equation after controlling for z is x=e+u
d_feas_base = lrd(theta,delta,beta,gamvec,etranx,etranz,[1],xgrids,zgrids,[0]);
d_feas_cf   = lrd(theta,delta,beta,gamvec,etranx,etranz,[1],xgrids_cf,zgrids,[0]);

lre_real = (d_real_cf-d_real_base)/dg0*(meanP+dg0/2)/((d_real_cf+d_real_base)/2);
lre_feas = (d_feas_cf-d_feas_base)/dg0*(meanP+dg0/2)/((d_feas_cf+d_feas_base)/2);
