function [lre_real lre_feas] = lre_simple(dg0,meanP,theta,delta,beta,gamvec,pix,pgrids,ugrids,tranu);
% dg0: the change in gamma0
% note that changes in gamma0 are one-to-one with changes in the mean price

theta = reshape(theta,2,1);
theta = [theta;1]; % coefficient on xi is 1 -- this wont matter in feasible version

T = size(pix,2);
M = size(pix,3);

% estimated transition matrices
etranp = estTrans(reshape(pix,T,M),pgrids);

% put the change in gamma0 into the e residual
pgrids_cf = pgrids + dg0;

% need to set gamma parameters to zero since we are replacing
% the price residual with the actual simulated price
d_real_base = lrd(theta,delta,beta,[0,0,0],etranp,[1],tranu,pgrids,[0],ugrids);
d_real_cf   = lrd(theta,delta,beta,[0,0,0],etranp,[1],tranu,pgrids_cf,[0],ugrids);

% in "feasible" counterfactual, unobserved demand shocks are fixed at zero
d_feas_base = lrd(theta,delta,beta,[0,0,0],etranp,[1],[1],pgrids,[0],[0]);
d_feas_cf   = lrd(theta,delta,beta,[0,0,0],etranp,[1],[1],pgrids_cf,[0],[0]);

lre_real = (d_real_cf-d_real_base)/dg0*(meanP+dg0/2)/((d_real_cf+d_real_base)/2);
lre_feas = (d_feas_cf-d_feas_base)/dg0*(meanP+dg0/2)/((d_feas_cf+d_feas_base)/2);
