#!/bin/bash

# this is a shell script that can be run to reproduce our Monte Carlo
# results
# software used: Matlab R2019b, Mathematica 11.3


# define location where you want to save output
RUNDIR=$SCRATCH/ECCP/
mkdir -p $RUNDIR

# define location where the replication code is located
CODEDIR=$HOME/ECCP/

cd $RUNDIR

# these were originally done in parallel, but I'll just put them here serially
# to facilitate reproduction
matlab -nodisplay -nodesktop -r "cd $RUNDIR; seed = 1; run $CODEDIR/MC_main.m;"
matlab -nodisplay -nodesktop -r "cd $RUNDIR; seed = 2; run $CODEDIR/MC_main.m;"
matlab -nodisplay -nodesktop -r "cd $RUNDIR; seed = 3; run $CODEDIR/MC_main.m;"
matlab -nodisplay -nodesktop -r "cd $RUNDIR; seed = 4; run $CODEDIR/MC_main.m;"
matlab -nodisplay -nodesktop -r "cd $RUNDIR; seed = 5; run $CODEDIR/MC_main.m;"
matlab -nodisplay -nodesktop -r "cd $RUNDIR; seed = 6; run $CODEDIR/MC_main.m;"
matlab -nodisplay -nodesktop -r "cd $RUNDIR; seed = 7; run $CODEDIR/MC_main.m;"
matlab -nodisplay -nodesktop -r "cd $RUNDIR; seed = 8; run $CODEDIR/MC_main.m;"
matlab -nodisplay -nodesktop -r "cd $RUNDIR; seed = 9; run $CODEDIR/MC_main.m;"
matlab -nodisplay -nodesktop -r "cd $RUNDIR; seed = 10; run $CODEDIR/MC_main.m;"


# collect and organize the results
matlab -nodisplay -nodesktop -r "cd $RUNDIR; seed = 10; run $CODEDIR/tables.m;"

# use mathematica to format the tables nicely
math -run < tables.nb
