
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%;
% Set primitives of the model;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%;

% Model Parameters: Preferences
theta = [1 -0.10 1]';     % Utility function parameters. Variables:
                          % constant, price, u
delta = 0.1;              % Probability of Product Failure/Death

% Model Parameters: Observed States p = g0 + g1 * z + g2 * u + error
gamma0   = 40;            % Intercept
gamma1   = 1;              % Coefficient on z
gamma2   = 1;              % Coefficient on u
gamvec = [gamma0,gamma1,gamma2];


% price shock that isn't correlated with demand shock
rho0_e   = 0;            % Intercept
rho1_e   = 0;          % Slope
sigma2_e = 4;           % Variance of shocks

% Model Parameters: Unobserved States u ~ AR(1)
rho0_u   = 0;            % Intercept
rho1_u   = 0.2;          % Slope
%sigma2_u = s2u;          % Variance of shocks

% Model Parameters: Instruments z ~ AR(1)
rho0_z   = 0;            % Intercept
rho1_z   = .7;            % Slope
sigma2_z = 25;            % Variance of shocks



% For Discretization
[zgrids,zgrids_half] = discretize(step,rho0_z,rho1_z,sqrt(sigma2_z));
[ugrids,ugrids_half] = discretize(step,rho0_u,rho1_u,sqrt(sigma2_u));
[egrids,egrids_half] = discretize(step,rho0_e,rho1_e,sqrt(sigma2_e));


meanP=gamma0 + gamma1*(rho0_z/(1-rho1_z)) + gamma2*(rho0_u/(1-rho1_u)) + (rho0_e/(1-rho1_e));
varP=(gamma1^2)*(sigma2_z)/(1-rho1_z^2) + (gamma2^2)*(sigma2_u)/(1-rho1_u^2) + sigma2_e/(1-rho1_e^2);


% Solve for the transition matrix of u
tranu=transition(ugrids,ugrids_half,rho0_u,rho1_u,sqrt(sigma2_u));

% Solve for the transition matrix of z
tranz=transition(zgrids,zgrids_half,rho0_z,rho1_z,sqrt(sigma2_z));

% Solve for the transition matrix of x (this is just a static distribution)
trane=transition(egrids,egrids_half,rho0_e,rho1_e,sqrt(sigma2_e));
