function x = sim_markov(trans,P0,N)
% forward simulate using transition matrix and initial distribution

C0 = cumsum(P0);
M = length(P0);

x = nan(N,1);
x(1) = (M + 1) - sum(rand <= C0);

for k = 2:N
    x(k) = (M + 1) - sum(rand <= cumsum(trans(x(k-1),:)));
end
