function [muAll ccp_agg] = stationary(ccp,trane,tranz,tranu,delta)
% calculate stationary distribution over market state variables

ne = size(trane,1);
nz = size(tranz,1);
nu = size(tranu,1);

[eigvec0,eigvl0]=eig(tranz'); %eigvec0: eigen vector, eigvl0: eigen values (diagonal matrix);
holdvec=eigvec0*(abs(spdiags(eigvl0)-1)<0.0000001);
st_distz=holdvec./sum(holdvec); %normalization so that the sum will be one.

[eigvec0,eigvl0]=eig(tranu'); %eigvec0: eigen vector, eigvl0: eigen values (diagonal matrix);
holdvec=eigvec0*(abs(spdiags(eigvl0)-1)<0.0000001);
st_distu=holdvec./sum(holdvec); %normalization so that the sum will be one.

% aggregate ccps over i.i.d. component of price shock
edist = reshape(trane(1,:),[1 1 ne 1 1]);
ccp_agg = edist(ones(2,1),ones(2,1),:,ones(nz,1),ones(nu,1)).*ccp;
ccp_agg = sum(ccp_agg,3);
ccp_agg = reshape(ccp_agg,[2 2 nz nu]);


% probability of transitioning to next k
trank = zeros(2,2,nz,nu);
trank(1,1,:,:) = ccp_agg(1,1,:,:);
trank(1,2,:,:) = 1-ccp_agg(1,1,:,:);
trank(2,1,:,:) = delta*ccp_agg(1,2,:,:);
trank(2,2,:,:) = ccp_agg(2,2,:,:) + (1-delta)*ccp_agg(1,2,:,:);

trank_temp = reshape(trank,[2 1 1 2 nz nu]);
tranz_temp = reshape(tranz,[1 nz 1 1 nz 1]);
tranu_temp = reshape(tranu,[1 1 nu 1 1 nu]);
tranAll = trank_temp(:,ones(nz,1),ones(nu,1),:,:,:).* ...
          tranz_temp(ones(2,1),:,ones(nu,1),ones(2,1),:,ones(nu,1)).* ...
          tranu_temp(ones(2,1),ones(nz,1),:,ones(2,1),ones(nz,1),:);

% stationary distribution over k,z,u
tranAllmat = reshape(tranAll,2*nu*nz,2*nu*nz);
[eigvec0,eigvl0]=eig(tranAllmat');
holdvec=eigvec0*(abs(spdiags(eigvl0)-1)<0.0000001);
st_distAll=holdvec./sum(holdvec);
muAll = reshape(st_distAll,[2 nz nu]);

% check it's consistent with marginal stationary distributions
%sum(sum(muAll,1),3)' - st_distz
%reshape(sum(sum(muAll,1),2)',nu,1) - st_distu
