% collect monte carlo results and prepare for presentation in tables


% notes:
% - macro shocks in the instrumental variable can cause small-sample bias
% - macro shocks in the demand shock (and probably the P residual) cause
% much larger standard errors, but no bias
% - these phenomena are pronounced for small-T cases, but not so much for large T

% ------------------------------------------------------------------------------
% load data

TNS = 5000;

thetaOLS_big        = zeros(3,3,2,2,TNS,2);
thetaIV_big         = zeros(3,3,2,2,TNS,2);
thetaHM_big         = zeros(3,3,2,2,TNS,2);
thetaHMs_big        = zeros(3,3,2,2,TNS,2);

lre_all = zeros(TNS,8);



for i = 1:10

  load(['MCresults', num2str(i), '.mat'])
  nstart = (i-1)*500 + 1;
  nend = i*500;

  thetaOLS_big(:,:,:,:,nstart:nend,:) = thetaOLS_all;
  thetaIV_big(:,:,:,:,nstart:nend,:) = thetaIV_all;
  thetaHS_big(:,:,:,:,nstart:nend,:) = thetaHM_all;
  thetaHMs_big(:,:,:,:,nstart:nend,:) = thetaHMs_all;

  lre_all(nstart:nend,:) = lreArray;

end

mean(reshape(thetaOLS_big(3,3,1,1,:,:),TNS,2))
mean(reshape(thetaOLS_big(3,3,2,2,:,:),TNS,2))
mean(reshape(thetaIV_big(3,3,1,1,:,:),TNS,2))
mean(reshape(thetaIV_big(3,3,2,2,:,:),TNS,2))
mean(reshape(thetaHMs_big(3,3,1,1,:,:),TNS,2))
mean(reshape(thetaHMs_big(3,3,2,2,:,:),TNS,2))

% order of indices:
% 1 - m
% 2 - t
% 3 - s2u
% 4 - lz

% ------------------------------------------------------------------------------
% TABLE basic
% no unobservable demand shocks

for s2ui = 1:2
for lzi = 1:2

  table1 = zeros(24,4);

  table1(1:8,1) = paramvec(thetaOLS_big(2,2,s2ui,lzi,:,:),[1 -.1]);
  table1(1:8,2) = paramvec(thetaOLS_big(1,3,s2ui,lzi,:,:),[1 -.1]);
  table1(1:8,3) = paramvec(thetaOLS_big(3,1,s2ui,lzi,:,:),[1 -.1]);
  table1(1:8,4) = paramvec(thetaOLS_big(3,3,s2ui,lzi,:,:),[1 -.1]);

  table1(9:16,1) = paramvec(thetaIV_big(2,2,s2ui,lzi,:,:),[1 -.1]);
  table1(9:16,2) = paramvec(thetaIV_big(1,3,s2ui,lzi,:,:),[1 -.1]);
  table1(9:16,3) = paramvec(thetaIV_big(3,1,s2ui,lzi,:,:),[1 -.1]);
  table1(9:16,4) = paramvec(thetaIV_big(3,3,s2ui,lzi,:,:),[1 -.1]);

  table1(17:24,1) = paramvec(thetaHMs_big(2,2,s2ui,lzi,:,:),[1 -.1]);
  table1(17:24,2) = paramvec(thetaHMs_big(1,3,s2ui,lzi,:,:),[1 -.1]);
  table1(17:24,3) = paramvec(thetaHMs_big(3,1,s2ui,lzi,:,:),[1 -.1]);
  table1(17:24,4) = paramvec(thetaHMs_big(3,3,s2ui,lzi,:,:),[1 -.1]);

  fileID = fopen(['table.s', num2str(s2ui), '.l', num2str(lzi), '.csv'],'w');
  formatSpec = '%6.8f,%6.8f,%6.8f,%6.8f  \n';
  fprintf(fileID,formatSpec,table1');
  fclose(fileID);

end
end


% ------------------------------------------------------------------------------
% Table LRE
% table with long-run elasticities


beta  = 0.95;             % Discount Factor
sigma2_u = s2u;          % Variance of shocksset_params;
set_params;


minx = min(ugrids) + min(egrids);
maxx = max(ugrids) + max(egrids);
xgrids = (minx:(1/step):maxx)';
xgrids_half=(minx:(1/(2*step)):maxx)';

tranu=transition(ugrids,ugrids_half,rho0_u,rho1_u,sqrt(sigma2_u));
tranz=transition(zgrids,zgrids_half,rho0_z,rho1_z,sqrt(sigma2_z));
trane=transition(egrids,egrids_half,rho0_e,rho1_e,sqrt(sigma2_e));
[tranAll1 tranAll2 tranX xgrids st_disteu st_distX euids] = trueTrans(trane,tranz,tranu,egrids,zgrids,ugrids,delta);


% true model LRE
dg0 = .01;
egrids_cf = egrids + dg0;
xgrids_cf = xgrids + dg0;
d_real_base = lrd(theta,delta,beta,gamvec,trane,tranz,tranu,egrids,zgrids,ugrids);
d_real_cf   = lrd(theta,delta,beta,gamvec,trane,tranz,tranu,egrids_cf,zgrids,ugrids);
d_feas_base = lrd(theta,delta,beta,gamvec,tranX,tranz,[1],xgrids,zgrids,[0]);
d_feas_cf   = lrd(theta,delta,beta,gamvec,tranX,tranz,[1],xgrids_cf,zgrids,[0]);
lre_real = (d_real_cf-d_real_base)/dg0*(meanP+dg0/2)/((d_real_cf+d_real_base)/2);
lre_feas = (d_feas_cf-d_feas_base)/dg0*(meanP+dg0/2)/((d_feas_cf+d_feas_base)/2);

% MC LRE estimates
lre_real_OLS = lre_all(:,1);
lre_feas_OLS = lre_all(:,2);
lre_real_IV = lre_all(:,3);
lre_feas_IV = lre_all(:,4);
lre_real_HM = lre_all(:,5);
lre_feas_HM = lre_all(:,6);
lre_real_HMs = lre_all(:,7);
lre_feas_HMs = lre_all(:,8);

lreTab = [[lre_real,0,0,0]',...
paramvec2(lre_real_OLS,lre_real),...
paramvec2(lre_real_IV,lre_real),...
paramvec2(lre_real_HMs,lre_real);...
[lre_feas,0,0,0]',...
paramvec2(lre_feas_OLS,lre_feas),...
paramvec2(lre_feas_IV,lre_feas),...
paramvec2(lre_feas_HMs,lre_feas)];


fileID = fopen('tableLRE.csv','w');
formatSpec = '%6.8f,%6.8f,%6.8f,%6.8f \n';
fprintf(fileID,formatSpec,lreTab');
fclose(fileID);
