function [vof] = transition(zgrids,zgrids_half, theta_0, theta_1, theta_2)

%This function computes the transition matrix for an AR(1) process.
%The function takes as inputs the number of evaluation points (nd), the
%evaluation grid and half grid (zgrids,zgrids_half) and the parameters of
%an AR process given by
%yt=theta_0 + theta_1*yt-1 + epsilon where epsilon ~ N(0,theta_2)
%The output of the function is the nd x nd transition matrix where
%vof(i,j)=Pr(z'=j,|z=i)

nd = size(zgrids,1);

if (theta_2 == 0)
  vof = eye(nd,nd);
else
  %Transition matrix for the benchmark;
  tranz_hold0=ones(nd,nd);
  tranz0=ones(nd,nd);
  for i=1:nd-1;
     tranz_hold0(:,i)=normcdf((zgrids_half(2*i)-theta_0-theta_1*zgrids)/theta_2);
  end;

  tranz0(:,1)=tranz_hold0(:,1);
  for i=2:nd;
     tranz0(:,i)=tranz_hold0(:,i)-tranz_hold0(:,i-1);
  end;

  vof=tranz0;
end
