function [tranAll1 tranAll2 tranX xgrids st_disteu st_distX euids] = trueTrans(trane,tranz,tranu,egrids,zgrids,ugrids,delta)
% transition process for observables, assuming xi unobservable
% note: assumes that each of these state variables are scaled
% to have the same grid spacing and to have a one-to-one
% relationship with price

ne = size(trane,1);
nz = size(tranz,1);
nu = size(tranu,1);

% stationary distributions of each independent state variable
st_distz = stationary_dist(tranz);
st_distu = stationary_dist(tranu);
st_diste = stationary_dist(trane);

% probability of transitioning to next k, conditional on action
trank1 = [1, 0; delta, 1-delta];
trank2 = [0, 1; 0, 1];

% joint transition process for e+u
trane_temp = reshape(trane,[ne 1 ne 1]);
tranu_temp = reshape(tranu,[1 nu 1 nu]);
traneu = tranu_temp(ones(ne,1),:,ones(ne,1),:).*trane_temp(:,ones(nu,1),:,ones(nu,1));
traneu = reshape(traneu,ne*nu,ne*nu);
euAll = egrids + ugrids';
euAll = reshape(euAll,ne*nu,1);

temp = reshape(st_distu,1,nu);
st_distu_tr = st_distu';
st_disteu = st_diste(:,ones(nu,1)).*st_distu_tr(ones(ne,1),:);
st_disteu = reshape(st_disteu,ne*nu,1);

% aggregate values of (e,u) that have the same sum
% then compute the aggregate transition matrix
[euVals,~,euids] = unique(euAll);
traneuC = num2cell(traneu',1);
tranX = cellfun(@(x) accumarray(euids,x),traneuC,'UniformOutput',false);
tranX = cell2mat(tranX)';
nX = size(tranX,2);

st_distX = accumarray(euids,st_disteu);
tranX = tranX.*st_disteu(:,ones(nX,1));
tranXC = num2cell(tranX,1);
tranX = cellfun(@(x) accumarray(euids,x),tranXC,'UniformOutput',false);
tranX = cell2mat(tranX);
tranX = tranX./st_distX(:,ones(nX,1));

% transition matrix for k and EU together
trank1_temp = reshape(trank1,[2 1 1 2 1 1]);
trank2_temp = reshape(trank2,[2 1 1 2 1 1]);
tranz_temp = reshape(tranz,[1 nz 1 1 nz 1]);
tranX_temp = reshape(tranX,[1 1 nX 1 1 nX]);
tranAll1 = trank1_temp(:,ones(nz,1),ones(nX,1),:,ones(nz,1),ones(nX,1)).* ...
           tranz_temp(ones(2,1),:,ones(nX,1),ones(2,1),:,ones(nX,1)).* ...
           tranX_temp(ones(2,1),ones(nz,1),:,ones(2,1),ones(nz,1),:);
tranAll2 = trank2_temp(:,ones(nz,1),ones(nX,1),:,ones(nz,1),ones(nX,1)).* ...
           tranz_temp(ones(2,1),:,ones(nX,1),ones(2,1),:,ones(nX,1)).* ...
           tranX_temp(ones(2,1),ones(nz,1),:,ones(2,1),ones(nz,1),:);

xgrids = euVals;




% summing over columns, each element will be 1
% > columns are "next" state, rows are current state
