function [ccp ev] = vf_solve(theta,delta,beta,gamvec,trane,tranz,tranu,egrids,zgrids,ugrids)
%This function performs the value function iteration to obtain the value
%functions in the Rust Bus Replacement model.

% this is how we indexing arrays:
% 1 - choice (1 is no purchase, 2 is purchase)
% 2 - ownership (1 is no ownership, 2 is ownership)
% 3 - price residual (not a persistant state variable, just something we need
%     to itegrate over)
% 4 - z, the supply shifting iv
% 5 - u, the demand shifter

nz = size(tranz,1);
nu = size(tranu,1);
ne = size(trane,1);

% ------------------------------------------------------------------------------
% some preliminaries
zarray = reshape(zgrids,[1 1 1 nz 1]);
uarray = reshape(ugrids,[1 1 1 1 nu]);
earray = reshape(egrids,[1 1 ne 1 1]);


parray = gamvec(1) + gamvec(2)*zarray(:,:,ones(ne,1),:,ones(nu,1)) ...
                   + gamvec(3)*uarray(:,:,ones(ne,1),ones(nz,1),:) ...
                   + earray(:,:,:,ones(nz,1),ones(nu,1));


% ------------------------------------------------------------------------------
% flow utilities conditional on states

% intercept term (consumption utility)
ucons = [0,theta(1);theta(1),theta(1)];
ucons = repmat(ucons,[1 1 ne nz nu]);

% price term
upay = [0,0;theta(2),theta(2)];
upay = repmat(upay,[1 1 ne nz nu]).*parray(ones(2,1),ones(2,1),:,:,:);

% stochastic new purchase quality shock
ubuy = [0,0;theta(3),theta(3)];
ubuy = repmat(ubuy,[1 1 ne nz nu]).*uarray(ones(1,2),ones(2,1),ones(ne,1),ones(nz,1),:);

flow = ucons + upay + ubuy;

% ------------------------------------------------------------------------------
% Solve value function

% array of conditional value functions
cv = zeros(2,2,ne,nz,nu);

% array of ex ante value functions
ev = zeros(2,ne,nz,nu);

diff=1; %initial value for the error;

while diff>10^-8; %iterate until the difference is less than 0.00001

  % future values conditional on choices, not yet integrating over market states
  fv = zeros(2,2,ne,nz,nu);
  fv(1,1,:,:,:) = ev(1,:,:,:);
  fv(1,2,:,:,:) = delta*ev(1,:,:,:)+(1-delta)*ev(2,:,:,:);
  fv(2,1,:,:,:) = ev(2,:,:,:);
  fv(2,2,:,:,:) = ev(2,:,:,:);

  xdist = trane(1,:);
  xdist = reshape(xdist,[1 1 ne 1 1]);

  % integrate over e shocks conditional on starting e
  trane_temp = trane'; % next period states are now first index
  trane_temp = reshape(trane_temp,[1 1 ne 1 1 ne]);
  % next, we have future values weighted by next state and current state
  fv = fv(:,:,:,:,:,ones(ne,1)).*trane_temp(ones(2,1),ones(2,1),:,ones(nz,1),ones(nu,1),:);
  % sum over next state
  fv = sum(fv,3);

  % similarly for z and u
  tranz_temp = tranz';
  tranz_temp = reshape(tranz_temp,[1 1 1 nz 1 1 nz]);
  fv = fv(:,:,:,:,:,:,ones(nz,1)).*tranz_temp(ones(2,1),ones(2,1),:,:,ones(nu,1),:,:);
  fv = sum(fv,4);

  tranu_temp = tranu';
  tranu_temp = reshape(tranu_temp,[1 1 1 1 nu 1 1 nu]);
  fv = fv(:,:,:,:,:,:,:,ones(nu,1)).*tranu_temp(ones(2,1),ones(2,1),:,:,:,:,:,:);
  fv = sum(fv,5);

  fv = reshape(fv,[2 2 ne nz nu]);

  % choice-specific value function
  cv = flow + beta*fv;

  % logit surplus formula
  evnew = log(sum(exp(cv),1)) + double(eulergamma);
  evnew = reshape(evnew,[2 ne nz nu]);

  % use the maximum norm
  diff = max(max(max(abs(evnew-ev))));

  % update the ev;
  ev = evnew;

end

% ------------------------------------------------------------------------------
% compute conditional choice probabilities
denom = sum(exp(cv),1);
ccp = exp(cv)./denom(ones(2,1),:,:,:,:);
